package gov.va.med.mhv.rxrefill.service.impl.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.rxrefill.data.model.Institution;
import gov.va.med.mhv.rxrefill.data.model.Request;
import gov.va.med.mhv.rxrefill.data.model.RequestAttempt;
import gov.va.med.mhv.rxrefill.data.repository.RequestRepository;
import gov.va.med.mhv.rxrefill.enums.RequestFunctionEnumeration;
import gov.va.med.mhv.rxrefill.exception.MHVRuntimeException;
import gov.va.med.mhv.rxrefill.util.RxMessagesUtil;

@Component
public class RxRequestStrategy {
	private static Logger log = LogManager.getLogger(RxRequestStrategy.class);
	
	private static final int MS_IN_ONE_DAY = 24 * 60 * 60 * 1000;
	private static final String DT_FORMAT = "yyyy-MM-dd HH:mm:ss";
	
	@Autowired
	private RxMessagesUtil rxMessagesUtil;

	@Autowired
	private RequestRepository requestRepository;

	public long getMaxTotalRxRequests() {
		return rxMessagesUtil.getRxrefillMaxConsecutiveRequests();

	}

	public long getMaxConsecutiveRxFailures() {
		return rxMessagesUtil.getRxrefillMaxConsecutiveFailures();
	}

	public static long getMaxRxProfileFailures() {
		// TODO - write implementation
		return 1;
	}

	private long getTodayRxRequests(Institution institution, Hashtable<Long, Long> htTodayRxRequests) {
		long todayRxRequests = 0;
		if (htTodayRxRequests.containsKey(institution.getInstitutionId())) {
			todayRxRequests = htTodayRxRequests.get(institution.
				getInstitutionId()).longValue();
		}
		return todayRxRequests;
	}

	private long getTodayConsecutiveRxFailures(Institution institution, Hashtable<Long, Long> htTodayRxConsecutiveFailures) {
		long todaySuccessiveRxFailures = 0;
		if (htTodayRxConsecutiveFailures.containsKey(institution
				.getInstitutionId())) {
			todaySuccessiveRxFailures = htTodayRxConsecutiveFailures.
				get(institution.getInstitutionId()).longValue();
		}
		return todaySuccessiveRxFailures;
	}
	
	public boolean isBelowRequestLimit(Institution institution, Hashtable<Long, Long> htTodayRxRequests, Hashtable<Long, Long> htTodayRxConsecutiveFailures) {
		return ((getMaxTotalRxRequests() <= 0) 
				|| (getTodayRxRequests(institution, htTodayRxRequests) < getMaxTotalRxRequests()))
			&& ((getMaxConsecutiveRxFailures() <= 0) 
			     || (getTodayConsecutiveRxFailures(institution, htTodayRxConsecutiveFailures) < 
			    		 getMaxConsecutiveRxFailures()));
	}
	
	private boolean isBelowRequestLimit_OLD(Long rxRequestSuccessCount, Long rxRequestFailureCount) {
		if(log.isDebugEnabled()){
			log.debug("In side RxRequestStrategy - isBelowRequestLimit - getMaxTotalRxRequests::"+getMaxTotalRxRequests()+" -- rxRequestSuccessCount::"+rxRequestSuccessCount);
			log.debug("In side RxRequestStrategy - isBelowRequestLimit - getMaxConsecutiveRxFailures::"+getMaxConsecutiveRxFailures()+" -- rxRequestFailureCount::"+rxRequestFailureCount);
		}
		System.out.println("In side RxRequestStrategy - isBelowRequestLimit - getMaxTotalRxRequests::"+getMaxTotalRxRequests()+" -- rxRequestSuccessCount::"+rxRequestSuccessCount);
		System.out.println("In side RxRequestStrategy - isBelowRequestLimit - getMaxConsecutiveRxFailures::"+getMaxConsecutiveRxFailures()+" -- rxRequestFailureCount::"+rxRequestFailureCount);

		/*
		 * (rxRequestSuccessCount + rxRequestFailedConsecutiveFailures) < getMaxTotalRxRequests()
		 */
		//Deleted adding Failure count to compare the Max refresh count against
		Long totalCountForTodayPerInstituition = rxRequestSuccessCount;
		
		
		System.out.println("**************isBelowRequestLimit ********** totalCountForTodayPerInstituition " + totalCountForTodayPerInstituition);
		//return (rxRequestSuccessCount > 0 && (getMaxTotalRxRequests() <= 0)  || (totalCountForTodayPerInstituition < getMaxTotalRxRequests()))
		//	&& ((getMaxConsecutiveRxFailures() <= 0) || (rxRequestFailedConsecutiveFailures < getMaxConsecutiveRxFailures()));
		return ((getMaxTotalRxRequests() <= 0)  || (totalCountForTodayPerInstituition < getMaxTotalRxRequests()))
		           && ((getMaxConsecutiveRxFailures() <= 0) || (rxRequestFailureCount < getMaxConsecutiveRxFailures()));
		// (false || true) && (false || true) 
			
		/*
		 * LEGACY Code
		return ((getMaxTotalRxRequests() <= 0)  FALSE
				|| (getTodayRxRequests(institution) < getMaxTotalRxRequests()))  TRUE
			&& ((getMaxConsecutiveRxFailures() <= 0) FALSE
			     || (getTodayConsecutiveRxFailures(institution) < 
			    		 getMaxConsecutiveRxFailures()));  TRUE
		*/
	}
	
	private Timestamp getFromTimestamp(Date now) {
		Date from = UtilityMethods.getDateWithoutTime(now);
		return UtilityMethods.dateToTimestamp(from);
	}
	
	private Timestamp getToTimestamp(Date now) {
		Date from = UtilityMethods.getDateWithoutTime(now);
		return UtilityMethods.dateToTimestamp(new Date(from.getTime() + MS_IN_ONE_DAY));
	}
	
	private Long[] getSuccessFailureCount(Long userProfileId, Long institutionId, int function) {	
		Long[] successFailureCount = new Long[2];
		Date now = new Date();
		
		try {
			Timestamp from = getFromTimestamp(now);
			Timestamp to = getToTimestamp(now);
			
			if(log.isDebugEnabled()) {
				DateFormat df = new SimpleDateFormat(DT_FORMAT);
				log.debug(String.format("Query Params: User Profile ID: %d, Funtion: %d, Institution ID: %d, From: %s, To: %s.", userProfileId, function, institutionId, df.format(from), df.format(to)));
			}
			
			successFailureCount[0] = this.requestRepository.countSuccessfulRequests(userProfileId, function, institutionId, from, to);
			successFailureCount[1] = this.requestRepository.countFailedRequests(userProfileId, function, institutionId, from, to);
			
			System.out.println("countSuccessfulRequestAttempts: " + successFailureCount[0] + " for user profile id: " + userProfileId + 
					" for function: " + function + " for institutionId: " + institutionId + " from date: " + from + " to date: " + to);
			
			System.out.println("countFailedRequestAttempts: " + successFailureCount[1]+ " for user profile id: " + userProfileId + 
					" for function: " + function + " for institutionId: " + institutionId + " from date: " + from + " to date: " + to);

		} catch (Exception ex) {
			String message = String.format("Error getting request success / failure counts. User Profile Id: %d, Insitution ID: %d, Function: %d", userProfileId, institutionId, function);
			log.error(message);
			throw new MHVRuntimeException(message, ex);
		}
		
		return successFailureCount;
	}
	
	public boolean checkSendActiveUpdateRequest(Patient patient, Institution institution,
			Hashtable<Long, Boolean> htHadSuccessfulProfileExtract,
			Hashtable<Long, Boolean> htHadSuccessfulActiveExtract, Hashtable<Long, Long> htTodayRxRequests,
			Hashtable<Long, Long> htTodayRxConsecutiveFailures) {

		// check if user had successful profile extract or active extract
		boolean result = (htHadSuccessfulProfileExtract.containsKey(institution.getInstitutionId())
				|| htHadSuccessfulActiveExtract.containsKey(institution.getInstitutionId()));

		// check request conditions
		result = result && isBelowRequestLimit(institution, htTodayRxRequests, htTodayRxConsecutiveFailures);

		return result;
	}

	public boolean checkSendHistoricalUpdateRequest(Patient patient, Institution institution,
			Hashtable<Long, Boolean> htHadSuccessfulProfileExtract, Hashtable<Long, Long> htTodayRxRequests,
			Hashtable<Long, Long> htTodayRxConsecutiveFailures) {

		// check if user had successful profile extract
		boolean result = (htHadSuccessfulProfileExtract.containsKey(institution.getInstitutionId()));

		// check request conditions
		result = result && isBelowRequestLimit(institution, htTodayRxRequests, htTodayRxConsecutiveFailures);

		return result;
	}
	
	public boolean checkSendStatusRequest(Patient patient, Institution institution,
			Hashtable<Long, Boolean> htHadSuccessfulProfileExtract,
			Hashtable<Long, Boolean> htHadSuccessfulActiveExtract, Hashtable<Long, Long> htTodayRxRequests,
			Hashtable<Long, Long> htTodayRxConsecutiveFailures) {
		verifyPatientAndInstitution(patient, institution);

		// check if user had successful full extract or active extract
		Long institutionId = institution.getInstitutionId();
		boolean result = (institutionId != null && !htHadSuccessfulProfileExtract.containsKey(institutionId)
				&& !htHadSuccessfulActiveExtract.containsKey(institutionId));
		// check request conditions
		result = result && isBelowRequestLimit(institution, htTodayRxRequests, htTodayRxConsecutiveFailures);

		return result;
	}
	
	public boolean checkSendActiveUpdateRequest_OLD(Patient patient, Institution institution) {

		Long[] profileSuccessFailureCounts = getSuccessFailureCount(patient.getUserProfileId(), institution.getId(), RequestFunctionEnumeration.GETPRESCRIPTIONPROFILE.getValue());
		Long[] activeSuccessFailureCounts = getSuccessFailureCount(patient.getUserProfileId(), institution.getId(), RequestFunctionEnumeration.GETPRESCRIPTIONSTATUS.getValue());
		Long[] profileUpdateSuccessFailureCounts = getSuccessFailureCount(patient.getUserProfileId(), institution.getId(), RequestFunctionEnumeration.GETPRESCRIPTIONUPDATE.getValue());
		
		
		boolean isActiveProfileSuccess = false;
		
		Long activeAndUpdateSuccess = profileSuccessFailureCounts[0] + activeSuccessFailureCounts[0];
		
		if(activeAndUpdateSuccess > 0) {
			
			isActiveProfileSuccess = true; 
		} else {
			isActiveProfileSuccess = false; 
		}
		
		// check request conditions
		boolean result = isActiveProfileSuccess && isBelowRequestLimit_OLD(profileSuccessFailureCounts[0], profileSuccessFailureCounts[1]) 
				&& isBelowRequestLimit_OLD(activeSuccessFailureCounts[0], activeSuccessFailureCounts[1]) 
				&& isBelowRequestLimit_OLD(profileUpdateSuccessFailureCounts[0], profileUpdateSuccessFailureCounts[1]) ;

		log.debug("In side RxRequestStrategy - checkSendActiveUpdateRequest - result of RequestLimit::"+result);

		return result;
	}

	public boolean checkSendHistoricalUpdateRequest_OLD(Patient patient, Institution institution) {
		
		Long[] profileSuccessFailureCounts = getSuccessFailureCount(patient.getUserProfileId(), institution.getId(), RequestFunctionEnumeration.GETPRESCRIPTIONPROFILE.getValue());
		Long[] activeSuccessFailureCounts = getSuccessFailureCount(patient.getUserProfileId(), institution.getId(), RequestFunctionEnumeration.GETPRESCRIPTIONSTATUS.getValue());
		Long[] profileUpdateSuccessFailureCounts = getSuccessFailureCount(patient.getUserProfileId(), institution.getId(), RequestFunctionEnumeration.GETPRESCRIPTIONUPDATE.getValue());
		

		boolean isActiveProfileSuccess = false;
		
		Long activeAndUpdateSuccess = profileSuccessFailureCounts[0];
		
		if(activeAndUpdateSuccess > 0) {
			
			isActiveProfileSuccess = true; 
		} else {
			isActiveProfileSuccess = false; 
		}
		
		// check request conditions
		boolean result = isActiveProfileSuccess && isBelowRequestLimit_OLD(profileSuccessFailureCounts[0], profileSuccessFailureCounts[1]) 
				&& isBelowRequestLimit_OLD(activeSuccessFailureCounts[0], activeSuccessFailureCounts[1]) 
				&& isBelowRequestLimit_OLD(profileUpdateSuccessFailureCounts[0], profileUpdateSuccessFailureCounts[1]) ;

		if(log.isDebugEnabled()){
			log.debug("In side RxRequestStrategy - checkSendHistoricalUpdateRequest - result after isBelowRequestLimit::"+result);
		}

		return result;
	} 


	public boolean checkSendStatusRequest_OLD(Patient patient, Institution institution)
	{
		verifyPatientAndInstitution(patient, institution);
		
		Long[] profileSuccessFailureCounts = getSuccessFailureCount(patient.getUserProfileId(), institution.getId(), RequestFunctionEnumeration.GETPRESCRIPTIONPROFILE.getValue());
		Long[] activeSuccessFailureCounts = getSuccessFailureCount(patient.getUserProfileId(), institution.getId(), RequestFunctionEnumeration.GETPRESCRIPTIONSTATUS.getValue());
		Long[] profileUpdateSuccessFailureCounts = getSuccessFailureCount(patient.getUserProfileId(), institution.getId(), RequestFunctionEnumeration.GETPRESCRIPTIONUPDATE.getValue());

		// check request conditions
		/*boolean result = institution.getInstitutionId() != null && isBelowRequestLimit(profileSuccessFailureCounts[0], profileSuccessFailureCounts[1]) 
				&& isBelowRequestLimit(activeSuccessFailureCounts[0], activeSuccessFailureCounts[1]);*/

		boolean isActiveProfileSuccess = false;
		
		Long activeAndUpdateSuccess = profileSuccessFailureCounts[0] + activeSuccessFailureCounts[0];
		
		if(activeAndUpdateSuccess == 0) {
			
			isActiveProfileSuccess = true; 
		} else {
			isActiveProfileSuccess = false; 
		}
		
		// check if user had successful full extract or active extract
		boolean result = isActiveProfileSuccess && institution.getInstitutionId() != null && isBelowRequestLimit_OLD(profileSuccessFailureCounts[0], profileSuccessFailureCounts[1]) 
				&& isBelowRequestLimit_OLD(activeSuccessFailureCounts[0], activeSuccessFailureCounts[1])
				&& isBelowRequestLimit_OLD(profileUpdateSuccessFailureCounts[0], profileUpdateSuccessFailureCounts[1]) ;

		return result;
	}

	private void verifyPatientAndInstitution(Patient patient, Institution institution) {
		if ((patient == null) || (institution == null)) {
			throw new IllegalArgumentException("patient and institution must BOTH be not null! patient=" +
				patient + ", institution=" + institution);
		}
	}

	/*
	 * result is going back as TRUE for SRE RxHistory
	 */
	public boolean checkSendProfileRequest_OLD(Patient patient,	Institution institution) {
		verifyPatientAndInstitution(patient, institution);
		
		/*
		htHadSuccessfulProfileExtract = new Hashtable<Long, Boolean>();
		
		for (Object r: RequestBO.getRequestsForPatientByFunction(patient.getUserProfile().getId(), RequestUtils.PROFILE_FUNCTION)) {
			Request request = ((RequestBO) r).getRequestValues();
			Long institutionId = request.getInstitution().getInstitutionId();
			if (RequestUtils.hasSucceeded(request)) {
				if (!htHadSuccessfulProfileExtract.containsKey(institutionId)) {
					htHadSuccessfulProfileExtract.put(institutionId,
						new Boolean(true));
				}
			}
		}
		*/
		
		Long[] profileSuccessFailureCounts = getSuccessFailureCount(patient.getUserProfileId(), institution.getId(), RequestFunctionEnumeration.GETPRESCRIPTIONPROFILE.getValue());
		Long[] activeSuccessFailureCounts = getSuccessFailureCount(patient.getUserProfileId(), institution.getId(), RequestFunctionEnumeration.GETPRESCRIPTIONSTATUS.getValue());
		Long[] profileUpdateSuccessFailureCounts = getSuccessFailureCount(patient.getUserProfileId(), institution.getId(), RequestFunctionEnumeration.GETPRESCRIPTIONUPDATE.getValue());
		
		System.out.println("checkSendProfileRequest:profileSuccessFailureCounts[0]" + profileSuccessFailureCounts[0]+" profileSuccessFailureCounts[1]:" + profileSuccessFailureCounts[1]);
		Long countProfileAttemptFailures = 0L;
		List listOfRequestsForUserForInstForProfileFunction = null;
		boolean result = false;
		
		Long totalCountForTodayPerInstituitionSuccess = profileSuccessFailureCounts[0] + activeSuccessFailureCounts[0] + profileUpdateSuccessFailureCounts[0];
		
		Long totalCountForTodayPerInstituitionFailure = profileSuccessFailureCounts[1] + activeSuccessFailureCounts[1] + profileUpdateSuccessFailureCounts[1];
	
		
		try {
			Date now = new Date();
			/*
			 * Retrieve failed request attempts for today
			 */
			/*countProfileAttemptFailures = this.requestRepository.countFailedRequestAttempts(patient.getUserProfileId(), 
					RequestFunctionEnumeration.GETPRESCRIPTIONPROFILE.getValue(), institution.getId(), 
					getFromTimestamp(now), getToTimestamp(now));*/
			listOfRequestsForUserForInstForProfileFunction = this.requestRepository.getRequests(patient.getUserProfileId(), RequestFunctionEnumeration.GETPRESCRIPTIONPROFILE.getValue(),
					institution.getId(), getFromTimestamp(now), getToTimestamp(now));
			if(listOfRequestsForUserForInstForProfileFunction!=null && !listOfRequestsForUserForInstForProfileFunction.isEmpty()){
				result = false;
			}else{
				result = true;
			}
			System.out.println("listOfRequestsForUserForInstForProfileFunction result: " + result); 
			
			/* Legacy logic
			    if (!htHadSuccessfulProfileExtract.containsKey(institutionId)) {
					System.out.println("!htHadSuccessfulProfileExtract.containsKey(institutionId) " + patient.
							getUserProfile().getId() + "and inst: " + institutionId);
					htHadSuccessfulProfileExtract.put(institutionId,
						new Boolean(true));
				}
				
				boolean result = !htHadSuccessfulProfileExtract.containsKey(institution
				.getInstitutionId());
			 */
			
			System.out.println("checkSendProfileRequest:countProfileAttemptFailures: " + profileSuccessFailureCounts[1]);
		} catch( Exception ex) {
			String message = String.format("Error getting request attempt failure counts. User Profile Id: %d, Insitution ID: %d, Function: %d", 
					patient.getUserProfileId(), institution.getId(), RequestFunctionEnumeration.GETPRESCRIPTIONPROFILE.getValue());
			log.error(message);
			throw new MHVRuntimeException(message, ex);
		}
		
		boolean isReachedLimitForFailures = profileSuccessFailureCounts[1] < getMaxRxProfileFailures();
		System.out.println("isReachedLimitForFailures: " + isReachedLimitForFailures);
		System.out.println("isBelowRequestLimit: " + isBelowRequestLimit_OLD(totalCountForTodayPerInstituitionSuccess, totalCountForTodayPerInstituitionFailure));
		// check request conditions
		return result && (isBelowRequestLimit_OLD(totalCountForTodayPerInstituitionSuccess, totalCountForTodayPerInstituitionFailure) && isReachedLimitForFailures);
		// return true && true;
	}
	/* LEGACY LOGIC result is going back as FALSE
		verifyPatientAndInstitution(patient, institution);
		initializeRxLogicData(patient);

		// check if user had successful full extract
		boolean result = !htHadSuccessfulProfileExtract.containsKey(institution
				.getInstitutionId());
		// check request conditions
		result (false) = result (false) && isBelowRequestLimit(institution) (true);

		// check max profile requests for today reached
		if(htTodayRxProfileFailures.containsKey(institution.getInstitutionId()))
		{
			long currProfileFailures = htTodayRxProfileFailures.get(institution.
				getInstitutionId()).longValue();
			result = result && (currProfileFailures < getMaxRxProfileFailures());
		}
		return result;
		*/

	public boolean checkSendProfileRequest(Patient patient, Institution institution,
			Hashtable<Long, Boolean> htHadSuccessfulProfileExtract, Hashtable<Long, Long> htTodayRxProfileFailures,
			Hashtable<Long, Long> htTodayRxRequests, Hashtable<Long, Long> htTodayRxConsecutiveFailures) {
		
		verifyPatientAndInstitution(patient, institution);

		// check if user had successful full extract
		boolean result = !htHadSuccessfulProfileExtract.containsKey(institution.getInstitutionId());
		System.out.println("Does htHadSuccessfulProfileExtract has inst key? " + result + "for patient: " + patient
				+ "and inst: " + institution);
		// check request conditions
		result = result && isBelowRequestLimit(institution, htTodayRxRequests, htTodayRxConsecutiveFailures);
		System.out.println("isBelowRequestLimit(institution): "
				+ isBelowRequestLimit(institution, htTodayRxRequests, htTodayRxConsecutiveFailures) + "for patient: "
				+ patient + "and inst: " + institution);
		System.out.println("Does htHadSuccessfulProfileExtract has inst key? + isBelowRequestLimit(institution):"
				+ result + "for patient: " + patient + "and inst: " + institution);

		// check max profile requests for today reached
		if (htTodayRxProfileFailures.containsKey(institution.getInstitutionId())) {
			long currProfileFailures = htTodayRxProfileFailures.get(institution.getInstitutionId()).longValue();
			System.out.println("currProfileFailures:" + currProfileFailures + "for patient: " + patient + "and inst: "
					+ institution);
			result = result && (currProfileFailures < getMaxRxProfileFailures());
			System.out.println("RESULT:" + result + "for patient: " + patient + "and inst: " + institution);

		}
		return result;
	}
	
	public boolean checkSendRefillRequest(Patient patient, Institution institution) {
		return true;
	}

	public Date checkRxExtractCutOffDate(Patient patient, Institution institution, Hashtable<Long, Date> htSuccessfulExtractRequests) 
	{
		return htSuccessfulExtractRequests.get(institution.getInstitutionId());
	}
	
	public Date checkRxExtractCutOffDate_OLD(Patient patient, Institution institution)
	{
		List<Request> extractRequests = null;
		Date latest = null;
		try {
			extractRequests = requestRepository.getLatestSuccessfulExtractRequests(patient.getUserProfile().getId(), institution.getId());
			if(extractRequests != null && extractRequests.size() > 0) {
				for (Request request : extractRequests) {
					for (RequestAttempt attempt : request.getRequestAttempts()) {
						
						if(latest == null || attempt.getCreatedDate().after(latest)) {
							latest = attempt.getCreatedDate();
						}
					}
				}
			}
		} catch(Exception e) {
			String message = String.format("Error getting last successful extract request for User Profile Id: %d, Institution Id: %d. ", 
					patient.getUserProfileId(), institution.getId());
			log.error(message , e);
			throw new MHVRuntimeException(message + e.getMessage(), e);
		}
		
		return latest;
	}
}
